<?php
/**
 * This is the main file for the drm.naphclinic.co.ke subdomain.
 * It operates from a separate directory but shares resources (header, footer, config)
 * with the main naphclinic.co.ke website.
 */

// Define a constant to indicate we are in a separate subdomain context.
// This will be used by the header and footer to resolve asset paths correctly.
define('IS_SUBDOMAIN_CONTEXT', true);

// Define the absolute public URL of the main site where shared assets are located.
// IMPORTANT: Update this to your live domain name.
define('MAIN_SITE_URL', 'https://naphclinic.co.ke');

// Define the server file path to the main site's root directory.
// This should point to the root directory of your main site on the server.
$main_site_path = __DIR__ . '/../../naphclinic.co.ke';

// Include shared files from the main site.
require_once $main_site_path . '/config.php';
include $main_site_path . '/includes/header.php';
?>

<!-- Hero Section -->
<section class="section hero-section">
    <div class="container">
        <div style="text-align: center;">
            <div class="hero-badge burgundy">
                <i class="fas fa-balance-scale-left"></i>
                DRM Services
            </div>
            <h1 class="hero-title">
                Dispute Resolution & <span class="hero-highlight">Mediation</span>
            </h1>
            <p class="hero-subtitle">
                A specialized division of NAPH Clinic dedicated to providing confidential, impartial, and effective dispute resolution services for individuals, families, and organizations.
            </p>
            <div class="hero-buttons">
                <a href="<?php echo rtrim(MAIN_SITE_URL, '/'); ?>/contact/" class="btn btn-primary" style="padding: 0.75rem 2rem;">Request a Consultation</a>
            </div>
        </div>
    </div>
</section>

<!-- About DRM Section -->
<section class="section bg-light">
    <div class="container">
        <div class="content-section">
            <div class="content-text">
                <h2 class="section-title burgundy">
                    <i class="fas fa-gavel"></i>
                    What is Dispute Resolution & Mediation?
                </h2>
                <p class="section-text">
                    Dispute Resolution and Mediation (DRM) is a structured, interactive process where an impartial third party (the mediator) assists disputing parties in resolving conflict through the use of specialized communication and negotiation techniques. Unlike traditional legal proceedings, mediation is a collaborative process focused on finding a "win-win" solution that meets the needs of all parties involved.
                </p>
                <p class="section-text">
                    Our goal at DRM.naphclinic.co.ke is to provide a safe, confidential, and constructive environment where conflicts can be resolved respectfully and efficiently, preserving relationships and avoiding the high costs and stress of litigation.
                </p>
            </div>
            <div>
                <img src="<?php echo $base_path; ?>assets/images/mediation.jpg"
                     alt="A calm and professional mediation session"
                     class="content-image">
            </div>
        </div>
    </div>
</section>

<!-- Who Can Benefit Section -->
<section class="section">
    <div class="container">
        <div class="section-header">
            <h2>Who Can Benefit from Our DRM Services?</h2>
            <p>Our services are designed for a wide range of situations and clients.</p>
        </div>
        <div class="grid grid-3">
            <div class="card">
                <div style="padding: 1.5rem; text-align: center;">
                    <div class="service-icon teal"><i class="fas fa-users"></i></div>
                    <h3 style="font-weight: 600;">Families & Couples</h3>
                    <p style="color: var(--slate-600);">Resolving disputes related to divorce, child custody, inheritance, and other family conflicts in a non-adversarial manner.</p>
                </div>
            </div>
            <div class="card">
                <div style="padding: 1.5rem; text-align: center;">
                    <div class="service-icon burgundy"><i class="fas fa-building"></i></div>
                    <h3 style="font-weight: 600;">Businesses & Workplaces</h3>
                    <p style="color: var(--slate-600);">Mediating conflicts between employees, departments, or business partners to restore a productive work environment.</p>
                </div>
            </div>
            <div class="card">
                <div style="padding: 1.5rem; text-align: center;">
                    <div class="service-icon teal"><i class="fas fa-home"></i></div>
                    <h3 style="font-weight: 600;">Landlords & Tenants</h3>
                    <p style="color: var(--slate-600);">Facilitating communication and agreements on issues like rent, repairs, and lease terms to avoid eviction or legal action.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Our Approach Section -->
<section class="section bg-light">
    <div class="container">
        <div class="section-header">
            <h2>Our Mediation Process</h2>
            <p>A structured approach to ensure a fair and effective resolution.</p>
        </div>
        <div class="grid grid-4">
            <div class="feature-box">
                <div class="feature-number">1</div>
                <h4 class="feature-title">Intake & Preparation</h4>
                <p>We begin with separate, confidential conversations with each party to understand the issues and prepare for the joint session.</p>
            </div>
            <div class="feature-box">
                <div class="feature-number">2</div>
                <h4 class="feature-title">Joint Session</h4>
                <p>The mediator facilitates a structured conversation, setting ground rules and allowing each party to express their perspective without interruption.</p>
            </div>
            <div class="feature-box">
                <div class="feature-number">3</div>
                <h4 class="feature-title">Exploration & Negotiation</h4>
                <p>We help identify common interests, brainstorm potential solutions, and guide negotiations towards a mutually acceptable agreement.</p>
            </div>
            <div class="feature-box">
                <div class="feature-number">4</div>
                <h4 class="feature-title">Agreement</h4>
                <p>Once a resolution is reached, the mediator drafts a formal agreement that outlines the terms, which can be made legally binding if desired.</p>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="section bg-burgundy">
    <div class="container" style="max-width: 64rem; text-align: center;">
        <h2 style="font-size: 1.875rem; font-weight: 700; margin-bottom: 1rem;">Find a Peaceful Resolution</h2>
        <p style="font-size: 1.25rem; margin-bottom: 2rem; opacity: 0.9;">
            Take the first step towards resolving your conflict constructively. Contact our DRM team for a confidential consultation.
        </p>
        <div style="display: flex; flex-wrap: wrap; gap: 1rem; justify-content: center;">
            <a href="<?php echo rtrim(MAIN_SITE_URL, '/'); ?>/contact/" class="btn btn-white" style="padding: 0.75rem 2rem; font-size: 1.125rem;">Schedule Consultation</a>
            <a href="tel:<?php echo str_replace(' ', '', $site_config['phone_primary']); ?>" class="btn" style="background: transparent; color: white; border: 2px solid white; padding: 0.75rem 2rem; font-size: 1.125rem;">
                <i class="fas fa-phone" style="margin-right: 0.5rem;"></i>
                Call <?php echo htmlspecialchars($site_config['phone_primary']); ?>
            </a>
        </div>
    </div>
</section>

<style>
.content-section { display: grid; grid-template-columns: 1fr 1fr; gap: 4rem; align-items: center; }
.content-image { width: 100%; border-radius: 1rem; box-shadow: 0 10px 25px rgba(0,0,0,0.1); }
.section-title { font-size: 1.875rem; font-weight: 700; margin-bottom: 1rem; display: flex; align-items: center; gap: 0.75rem; }
.section-title.burgundy { color: var(--naph-burgundy); }
.section-title.teal { color: var(--naph-teal); }
.section-text { color: var(--slate-600); line-height: 1.7; font-size: 1.125rem; margin-bottom: 1.5rem; }
.feature-box { text-align: center; padding: 1rem; }
.feature-number { width: 3rem; height: 3rem; border-radius: 50%; background-color: var(--naph-teal); color: white; display: flex; align-items: center; justify-content: center; font-size: 1.25rem; font-weight: 700; margin: 0 auto 1rem; }
.feature-title { font-weight: 600; color: var(--slate-800); margin-bottom: 0.5rem; }
@media (max-width: 768px) {
    .content-section { grid-template-columns: 1fr; }
    .content-section > div:first-child { order: 2; }
}
</style>

<?php
// Include the shared footer.
include $main_site_path . '/includes/footer.php';
?>